/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.cards.i.InfiniteAuthorityEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InfiniteAuthorityTriggeredAbility
extends TriggeredAbilityImpl {
    InfiniteAuthorityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateDelayedTriggeredAbilityEffect(new AtTheEndOfCombatDelayedTriggeredAbility((Effect)new InfiniteAuthorityEffect()).setTriggerPhrase("")));
        this.setTriggerPhrase("Whenever enchanted creature blocks or becomes blocked by a creature with toughness 3 or less, ");
    }

    private InfiniteAuthorityTriggeredAbility(InfiniteAuthorityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public InfiniteAuthorityTriggeredAbility copy() {
        return new InfiniteAuthorityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantedCreature;
        Permanent aura = game.getPermanentOrLKIBattlefield(this.sourceId);
        if (aura != null && (enchantedCreature = game.getPermanentOrLKIBattlefield(aura.getAttachedTo())) != null) {
            Permanent blocker = game.getPermanent(event.getSourceId());
            Permanent blocked = game.getPermanent(event.getTargetId());
            Effect effect = (Effect)this.getEffects().get(0);
            if (blocker != null && Objects.equals(blocked, enchantedCreature) && blocker.getToughness().getValue() <= 3) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(blocker.getId(), game));
                return true;
            }
            if (blocked != null && Objects.equals(blocker, enchantedCreature) && blocked.getToughness().getValue() <= 3) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(blocked.getId(), game));
                return true;
            }
        }
        return false;
    }
}

