/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class InfiniteReflectionEntersBattlefieldEffect
extends ReplacementEffectImpl {
    InfiniteReflectionEntersBattlefieldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Nontoken creatures you control enter the battlefield as a copy of enchanted creature";
    }

    private InfiniteReflectionEntersBattlefieldEffect(InfiniteReflectionEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game) && !(permanent instanceof PermanentToken);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent toCopyFromPermanent;
        Permanent toCopyToObject = ((EntersTheBattlefieldEvent)event).getTarget();
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && toCopyToObject != null && sourcePermanent.getAttachedTo() != null && (toCopyFromPermanent = game.getPermanent(sourcePermanent.getAttachedTo())) != null) {
            game.copyPermanent(toCopyFromPermanent, toCopyToObject.getId(), source, (CopyApplier)new EmptyCopyApplier());
        }
        return false;
    }

    public InfiniteReflectionEntersBattlefieldEffect copy() {
        return new InfiniteReflectionEntersBattlefieldEffect(this);
    }
}

