/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class InfiniteReflectionTriggeredEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    public InfiniteReflectionTriggeredEffect() {
        super(Outcome.Sacrifice);
        this.staticText = " attached to a creature, each other nontoken creature you control becomes a copy of that creature";
    }

    private InfiniteReflectionTriggeredEffect(InfiniteReflectionTriggeredEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfiniteReflectionTriggeredEffect copy() {
        return new InfiniteReflectionTriggeredEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent toCopyFromPermanent;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && sourcePermanent.getAttachedTo() != null && (toCopyFromPermanent = game.getPermanent(sourcePermanent.getAttachedTo())) != null) {
            for (Permanent toCopyToPermanent : game.getBattlefield().getAllActivePermanents(filter, source.getControllerId(), game)) {
                if (toCopyToPermanent.equals(toCopyFromPermanent) || toCopyToPermanent instanceof PermanentToken) continue;
                game.copyPermanent(toCopyFromPermanent, toCopyToPermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            }
            return true;
        }
        return false;
    }
}

