/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.i.InkTreaderNephilimEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.util.TargetAddress;

class InkTreaderNephilimTriggeredAbility
extends TriggeredAbilityImpl {
    InkTreaderNephilimTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InkTreaderNephilimEffect(), false);
    }

    private InkTreaderNephilimTriggeredAbility(InkTreaderNephilimTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public InkTreaderNephilimTriggeredAbility copy() {
        return new InkTreaderNephilimTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.isInstantOrSorcery(game)) {
            this.getEffects().setValue("triggeringSpell", (Object)spell);
            return true;
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Spell spell = (Spell)((Effect)this.getEffects().get(0)).getValue("triggeringSpell");
        if (spell == null) {
            return false;
        }
        boolean flag = false;
        for (TargetAddress addr : TargetAddress.walk((Card)spell)) {
            Target targetInstance = addr.getTarget(spell);
            for (UUID target : targetInstance.getTargets()) {
                if (target == null) continue;
                Permanent permanent = game.getPermanent(target);
                if (permanent == null || !permanent.getId().equals(this.getSourceId())) {
                    return false;
                }
                if (this.getStackMomentSourceZCC() != 0 && this.getStackMomentSourceZCC() != permanent.getZoneChangeCounter(game)) {
                    return false;
                }
                flag = true;
            }
        }
        return flag;
    }

    public String getRule() {
        return "Whenever a player casts an instant or sorcery spell, if that spell targets only {this}, copy the spell for each other creature that spell could target. Each copy targets a different one of those creatures.";
    }
}

