/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class InnkeepersTalentEffect
extends ReplacementEffectImpl {
    InnkeepersTalentEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature, false);
        this.staticText = "if you would put one or more counters on a permanent or player, put twice that many of each of those kinds of counters on that permanent or player instead";
    }

    private InnkeepersTalentEffect(InnkeepersTalentEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowMultiply((int)event.getAmount(), (int)2), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player targetPlayer = game.getPlayer(event.getTargetId());
        Permanent targetPermanent = game.getPermanentEntering(event.getTargetId());
        if (targetPermanent == null) {
            targetPermanent = game.getPermanent(event.getTargetId());
        }
        if (targetPlayer == null && targetPermanent == null) {
            return false;
        }
        return source.isControlledBy(event.getPlayerId());
    }

    public InnkeepersTalentEffect copy() {
        return new InnkeepersTalentEffect(this);
    }
}

