/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class InnocentTravelerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature to sacrifice");

    InnocentTravelerEffect() {
        super(Outcome.Benefit);
        this.staticText = "any opponent may sacrifice a creature. If no one does, transform {this}";
    }

    private InnocentTravelerEffect(InnocentTravelerEffect effect) {
        super((OneShotEffect)effect);
    }

    public InnocentTravelerEffect copy() {
        return new InnocentTravelerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean flag = false;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Permanent permanent;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            if (!target.canChoose(opponent.getId(), source, game) || !opponent.chooseUse(Outcome.AIDontUseIt, "Sacrifice a creature?", source, game) || !opponent.choose(Outcome.Sacrifice, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null || !permanent.sacrifice(source, game)) continue;
            flag = true;
        }
        if (flag) {
            return true;
        }
        Permanent sourcePerm = source.getSourcePermanentIfItStillExists(game);
        if (sourcePerm != null) {
            sourcePerm.transform(source, game);
        }
        return true;
    }
}

