/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class InnocuousResearcherEffect
extends ContinuousRuleModifyingEffectImpl {
    InnocuousResearcherEffect() {
        super(Duration.UntilYourNextTurn, Outcome.PreventCast);
        this.staticText = "you can't cast spells until your next turn";
    }

    private InnocuousResearcherEffect(InnocuousResearcherEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public InnocuousResearcherEffect copy() {
        return new InnocuousResearcherEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells until your next turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

