/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class InquisitorsFlailEffect
extends ReplacementEffectImpl {
    InquisitorsFlailEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If equipped creature would deal combat damage, it deals double that damage instead.<br>If another creature would deal combat damage to equipped creature, it deals double that damage to equipped creature instead";
    }

    private InquisitorsFlailEffect(InquisitorsFlailEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public InquisitorsFlailEffect copy() {
        return new InquisitorsFlailEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent equipment;
        if (((DamageEvent)event).isCombatDamage() && (equipment = game.getPermanent(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            UUID attachedTo = equipment.getAttachedTo();
            if (event.getSourceId().equals(attachedTo)) {
                return true;
            }
            if (event.getTargetId().equals(attachedTo)) {
                return true;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

