/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.CustomIllusionToken;
import mage.players.Player;

class InscriptionOfInsightEffect
extends OneShotEffect {
    InscriptionOfInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player creates an X/X blue Illusion creature token, where X is the number of cards in their hand.";
    }

    private InscriptionOfInsightEffect(InscriptionOfInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public InscriptionOfInsightEffect copy() {
        return new InscriptionOfInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        return new CustomIllusionToken(player.getHand().size()).putOntoBattlefield(1, game, source, source.getFirstTarget());
    }
}

