/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class IntellectualOfferingUntapEffect
extends OneShotEffect {
    IntellectualOfferingUntapEffect() {
        super(Outcome.Untap);
        this.staticText = "<br><br>Choose an opponent. Untap all nonland permanents you control and all nonland permanents that player controls";
    }

    private IntellectualOfferingUntapEffect(IntellectualOfferingUntapEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntellectualOfferingUntapEffect copy() {
        return new IntellectualOfferingUntapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetOpponent target = new TargetOpponent(true);
            target.choose(Outcome.Untap, source.getControllerId(), source.getSourceId(), source, game);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterNonlandPermanent(), player.getId(), game)) {
                permanent.untap(game);
            }
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterNonlandPermanent(), opponent.getId(), game)) {
                    permanent.untap(game);
                }
                return true;
            }
        }
        return false;
    }
}

