/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.i.InterdictCantActivateEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InterdictCounterEffect
extends OneShotEffect {
    InterdictCounterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target activated ability from an artifact, creature, enchantment, or land. That permanent's activated abilities can't be activated this turn.";
    }

    private InterdictCounterEffect(InterdictCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public InterdictCounterEffect copy() {
        return new InterdictCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        if (stackObject != null && game.getStack().counter(source.getFirstTarget(), source, game)) {
            Permanent sourcePermanent = stackObject.getStackAbility().getSourcePermanentIfItStillExists(game);
            if (sourcePermanent != null) {
                InterdictCantActivateEffect effect = new InterdictCantActivateEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent, game));
                game.getContinuousEffects().addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

