/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class IntoTheNightEffect
extends OneShotEffect {
    IntoTheNightEffect() {
        super(Outcome.Benefit);
        this.staticText = "it becomes night. Discard any number of cards, then draw that many cards plus one";
    }

    private IntoTheNightEffect(IntoTheNightEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntoTheNightEffect copy() {
        return new IntoTheNightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.setDaytime(false);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(player.discard(0, Integer.MAX_VALUE, false, source, game).size() + 1, source, game);
        return true;
    }
}

