/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IntoTheWildsEffect
extends OneShotEffect {
    IntoTheWildsEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield";
    }

    private IntoTheWildsEffect(IntoTheWildsEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntoTheWildsEffect copy() {
        return new IntoTheWildsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            String message;
            controller.lookAtCards(source, "", (Cards)new CardsImpl(card), game);
            if (card.isLand(game) && controller.chooseUse(this.outcome, message = "Put " + card.getName() + " onto the battlefield?", source, game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }
}

