/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterAnyTarget;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.common.TargetPermanentOrPlayer;

class InvasionOfTarkirEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Dragon cards");
    private static final FilterPermanentOrPlayer filter2 = new FilterAnyTarget("any other target");

    InvasionOfTarkirEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal any number of Dragon cards from your hand. When you do, {this} deals X plus 2 damage to any other target, where X is the number of cards revealed this way";
    }

    private InvasionOfTarkirEffect(InvasionOfTarkirEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfTarkirEffect copy() {
        return new InvasionOfTarkirEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, Integer.MAX_VALUE, filter);
        player.choose(Outcome.Benefit, player.getHand(), (TargetCard)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.revealCards(source, (Cards)cards, game);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(cards.size() + 2), false);
        ability.addTarget((Target)new TargetPermanentOrPlayer(filter2));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((Predicate)SubType.DRAGON.getPredicate());
        filter2.getPermanentFilter().add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

