/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.RandomUtil;

class InventiveIterationEffect
extends OneShotEffect {
    InventiveIterationEffect() {
        super(Outcome.Benefit);
        this.staticText = "return an artifact card from your graveyard to your hand. If you can't, draw a card";
    }

    private InventiveIterationEffect(InventiveIterationEffect effect) {
        super((OneShotEffect)effect);
    }

    public InventiveIterationEffect copy() {
        return new InventiveIterationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        switch (player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game)) {
            case 0: {
                player.drawCards(1, source, game);
                return true;
            }
            case 1: {
                card = (Card)RandomUtil.randomFromCollection((Collection)player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT, game));
                break;
            }
            default: {
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT);
                target.withNotTarget(true);
                player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        player.moveCards(card, Zone.HAND, source, game);
        return true;
    }
}

