/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class InvincibleHymnEffect
extends OneShotEffect {
    InvincibleHymnEffect() {
        super(Outcome.Neutral);
        this.staticText = "Count the number of cards in your library. Your life total becomes that number";
    }

    private InvincibleHymnEffect(InvincibleHymnEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvincibleHymnEffect copy() {
        return new InvincibleHymnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int oldValue;
            int newValue = player.getLibrary().size();
            if (newValue - (oldValue = player.getLife()) > 0) {
                player.gainLife(newValue - oldValue, game, source);
            }
            if (oldValue - newValue > 0) {
                player.loseLife(oldValue - newValue, game, source, false);
            }
            return true;
        }
        return false;
    }
}

