/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.i.InvokePrejudiceEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InvokePrejudiceTriggeredAbility
extends TriggeredAbilityImpl {
    public InvokePrejudiceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new InvokePrejudiceEffect(), false);
        this.setTriggerPhrase("Whenever an opponent casts a creature spell that doesn't share a color with a creature you control, ");
    }

    private InvokePrejudiceTriggeredAbility(InvokePrejudiceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public InvokePrejudiceTriggeredAbility copy() {
        return new InvokePrejudiceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId()) && (spell = (Spell)game.getObject(event.getTargetId())) != null && spell.isCreature(game)) {
            boolean creatureSharesAColor = false;
            ObjectColor spellColor = spell.getColor(game);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), this.getControllerId(), game)) {
                if (!spellColor.shares(permanent.getColor(game))) continue;
                creatureSharesAColor = true;
                break;
            }
            if (!creatureSharesAColor) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
                }
                return true;
            }
        }
        return false;
    }
}

