/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class IsochronScepterImprintEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("instant card with mana value 2 or less from your hand");

    public IsochronScepterImprintEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile an instant card with mana value 2 or less from your hand";
    }

    private IsochronScepterImprintEffect(IsochronScepterImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null) {
            Card card;
            TargetCard target;
            if (!controller.getHand().isEmpty() && (target = new TargetCard(Zone.HAND, filter)).canChoose(source.getControllerId(), source, game) && controller.choose(Outcome.Benefit, controller.getHand(), target, source, game) && (card = controller.getHand().get(target.getFirstTarget(), game)) != null) {
                controller.moveCardsToExile(card, source, game, true, source.getSourceId(), sourcePermanent.getIdName() + " (Imprint)");
                Permanent permanent = game.getPermanent(source.getSourceId());
                if (permanent != null) {
                    permanent.imprint(card.getId(), game);
                    permanent.addInfo("imprint", CardUtil.addToolTipMarkTags((String)("[Imprinted card - " + card.getLogName() + ']')), game);
                }
            }
            return true;
        }
        return false;
    }

    public IsochronScepterImprintEffect copy() {
        return new IsochronScepterImprintEffect(this);
    }

    static {
        filter.add((Predicate)CardType.INSTANT.getPredicate());
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

