/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class IsperiaTheInscrutableEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature card with flying");

    public IsperiaTheInscrutableEffect() {
        super(Outcome.Neutral);
        this.staticText = "That player reveals their hand. If a card with the chosen name is revealed this way, search your library for a creature card with flying, reveal it, put it into your hand, then shuffle";
    }

    private IsperiaTheInscrutableEffect(IsperiaTheInscrutableEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (player != null && cardName != null) {
            player.revealCards(player.getLogName() + " hand", player.getHand(), game, true);
            for (Card card : player.getHand().getCards(game)) {
                if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                return new SearchLibraryPutInHandEffect(new TargetCardInLibrary(filter), true).apply(game, source);
            }
            return true;
        }
        return false;
    }

    public IsperiaTheInscrutableEffect copy() {
        return new IsperiaTheInscrutableEffect(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

