/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Arrays;
import java.util.Iterator;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.functions.StackObjectCopyApplier;

class IvyGleefulSpellthiefEffect
extends OneShotEffect {
    IvyGleefulSpellthiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "copy that spell. The copy targets {this}";
    }

    private IvyGleefulSpellthiefEffect(IvyGleefulSpellthiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public IvyGleefulSpellthiefEffect copy() {
        return new IvyGleefulSpellthiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = (Spell)this.getValue("spellCast");
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (spell == null || permanent == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), false, 1, (StackObjectCopyApplier)new IvyGleefulSpellthiefApplier(permanent, game));
        return true;
    }

    private static final class IvyGleefulSpellthiefApplier
    implements StackObjectCopyApplier {
        private final Iterator<MageObjectReferencePredicate> predicate;

        IvyGleefulSpellthiefApplier(Permanent permanent, Game game) {
            this.predicate = Arrays.asList(new MageObjectReferencePredicate((MageObject)permanent, game)).iterator();
        }

        public void modifySpell(StackObject stackObject, Game game) {
        }

        public MageObjectReferencePredicate getNextNewTargetType() {
            if (this.predicate.hasNext()) {
                return this.predicate.next();
            }
            return null;
        }
    }
}

