/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;

class IwamoriOfTheOpenFistEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("legendary creature card");

    public IwamoriOfTheOpenFistEffect() {
        super(Outcome.Detriment);
        this.staticText = "each opponent may put a legendary creature card from their hand onto the battlefield";
    }

    private IwamoriOfTheOpenFistEffect(IwamoriOfTheOpenFistEffect effect) {
        super((OneShotEffect)effect);
    }

    public IwamoriOfTheOpenFistEffect copy() {
        return new IwamoriOfTheOpenFistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl();
            for (UUID playerId : game.getOpponents(controller.getId())) {
                Card card;
                Player opponent = game.getPlayer(playerId);
                Target target = new TargetCard(0, 1, Zone.HAND, filter).withChooseHint("put from hand to battlefield");
                if (!target.choose(Outcome.PutCreatureInPlay, opponent.getId(), source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                cards.add(card);
            }
            controller.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

