/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class IzzetStaticasterDamageEffect
extends OneShotEffect {
    IzzetStaticasterDamageEffect() {
        super(Outcome.Exile);
        this.staticText = "{this} deals 1 damage to target creature and each other creature with the same name as that creature";
    }

    private IzzetStaticasterDamageEffect(IzzetStaticasterDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public IzzetStaticasterDamageEffect copy() {
        return new IzzetStaticasterDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetPermanent != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
                filter.add((Predicate)new PermanentIdPredicate(targetPermanent.getId()));
            } else {
                filter.add((Predicate)new NamePredicate(targetPermanent.getName()));
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                permanent.damage(1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

