/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.DamagedByWatcher;

class CantRegenerateEffect
extends ContinuousRuleModifyingEffectImpl {
    CantRegenerateEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "A creature dealt damage this way can't be regenerated this turn";
    }

    private CantRegenerateEffect(CantRegenerateEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CantRegenerateEffect copy() {
        return new CantRegenerateEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REGENERATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        DamagedByWatcher watcher = (DamagedByWatcher)game.getState().getWatcher(DamagedByWatcher.class, source.getSourceId());
        return watcher != null && watcher.wasDamaged(event.getTargetId(), game);
    }
}

