/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.j.HolgaRelentlessRagerPredicate;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HolgaRelentlessRagerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    HolgaRelentlessRagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each creature you control attacking a player gets +1/+0 until end of turn for each creature that player controls";
    }

    private HolgaRelentlessRagerEffect(HolgaRelentlessRagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HolgaRelentlessRagerEffect copy() {
        return new HolgaRelentlessRagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, game.getCombat().getDefenderId(permanent.getId()), source, game);
            if (count <= 0) continue;
            game.addEffect(new BoostTargetEffect(count, 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }

    static {
        filter.add((Predicate)HolgaRelentlessRagerPredicate.instance);
    }
}

