/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class JabarisInfluenceWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> attackedThisTurnCreatures = new HashMap<MageObjectReference, Set<UUID>>();

    public JabarisInfluenceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED && (permanent = game.getPermanent(event.getSourceId())) != null) {
            this.attackedThisTurnCreatures.computeIfAbsent(new MageObjectReference(event.getSourceId(), game), u -> new HashSet()).add(event.getTargetId());
        }
    }

    boolean checkIfCreatureAttackedYouThisTurn(Permanent permanent, UUID playerId, Game game) {
        MageObjectReference mor = new MageObjectReference((MageObject)permanent, game);
        return this.attackedThisTurnCreatures.containsKey(mor) && this.attackedThisTurnCreatures.get(mor).contains(playerId);
    }

    public void reset() {
        super.reset();
        this.attackedThisTurnCreatures.clear();
    }
}

