/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class JaceMindseekerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterInstantOrSorceryCard();

    public JaceMindseekerEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "target opponent mills five cards. You may cast an instant or sorcery spell from among them without paying its mana cost.";
    }

    private JaceMindseekerEffect(JaceMindseekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaceMindseekerEffect copy() {
        return new JaceMindseekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)opponent.millCards(5, source, game), (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
    }
}

