/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class JaceTheMindSculptorEffect1
extends OneShotEffect {
    public JaceTheMindSculptorEffect1() {
        super(Outcome.Detriment);
        this.staticText = "Look at the top card of target player's library. You may put that card on the bottom of that player's library";
    }

    private JaceTheMindSculptorEffect1(JaceTheMindSculptorEffect1 effect) {
        super((OneShotEffect)effect);
    }

    public JaceTheMindSculptorEffect1 copy() {
        return new JaceTheMindSculptorEffect1(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller != null && player != null && (card = player.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.lookAtCards("Jace, the Mind Sculptor", (Cards)cards, game);
            if (controller.chooseUse(this.outcome, "Put that card on the bottom of its owner's library?", source, game)) {
                controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, false, false);
            } else {
                game.informPlayers(controller.getLogName() + " puts the card back on top of the library.");
            }
            return true;
        }
        return false;
    }
}

