/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class JaceTheMindSculptorEffect2
extends OneShotEffect {
    public JaceTheMindSculptorEffect2() {
        super(Outcome.DrawCard);
        this.staticText = "Exile all cards from target player's library, then that player shuffles their hand into their library";
    }

    private JaceTheMindSculptorEffect2(JaceTheMindSculptorEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public JaceTheMindSculptorEffect2 copy() {
        return new JaceTheMindSculptorEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetPlayer != null) {
            controller.moveCards(targetPlayer.getLibrary().getTopCards(game, targetPlayer.getLibrary().size()), Zone.EXILED, source, game);
            targetPlayer.moveCards(targetPlayer.getHand(), Zone.LIBRARY, source, game);
            targetPlayer.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

