/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class JacobFryeEffect
extends OneShotEffect {
    JacobFryeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to one target Assassin card or card with freerunning from your graveyard. If you do, copy it. You may cast the copy";
    }

    private JacobFryeEffect(JacobFryeEffect effect) {
        super((OneShotEffect)effect);
    }

    public JacobFryeEffect copy() {
        return new JacobFryeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        Card copiedCard = game.copyCard(card, source, source.getControllerId());
        copiedCard.setZone(Zone.OUTSIDE, game);
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(copiedCard, game, false), game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }
}

