/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class JadziOracleOfArcaviosEffect
extends OneShotEffect {
    JadziOracleOfArcaviosEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If it's a nonland card, you may cast it by paying {1} rather than paying its mana cost. If it's a land card, put it onto the battlefield";
    }

    private JadziOracleOfArcaviosEffect(JadziOracleOfArcaviosEffect effect) {
        super((OneShotEffect)effect);
    }

    public JadziOracleOfArcaviosEffect copy() {
        return new JadziOracleOfArcaviosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isLand(game)) {
            return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (!controller.chooseUse(this.outcome, "Cast revealed card " + card.getName() + " by paying {1}?", source, game)) {
            return false;
        }
        CardUtil.castSingle((Player)controller, (Ability)source, (Game)game, (Card)card, (ManaCostsImpl)new ManaCostsImpl("{1}"));
        return true;
    }
}

