/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetControlledPermanent;

class JalumGrifterEffect
extends OneShotEffect {
    JalumGrifterEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Shuffle {this} and two lands you control face down. Target opponent chooses one of those cards. Turn the cards face up. If they chose {this}, sacrifice it. Otherwise, destroy target permanent";
    }

    private JalumGrifterEffect(JalumGrifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public JalumGrifterEffect copy() {
        return new JalumGrifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        if (controller != null && opponent != null) {
            Card card;
            TargetControlledPermanent target;
            ArrayList<Card> shellGamePile = new ArrayList<Card>();
            Card sourceCard = game.getCard(source.getSourceId());
            if (sourceCard != null) {
                sourceCard = sourceCard.copy();
                sourceCard.setFaceDown(true, game);
                shellGamePile.add(sourceCard);
                game.informPlayers(controller.getLogName() + " turns " + sourceCard.getLogName() + " face down");
            }
            if ((target = new TargetControlledPermanent(2, 2, (FilterControlledPermanent)new FilterControlledLandPermanent(), true)).canChoose(controller.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target, source, game);
                }
            }
            for (UUID cardId : target.getTargets()) {
                card = game.getCard(cardId);
                if (card == null) continue;
                card = card.copy();
                card.setFaceDown(true, game);
                shellGamePile.add(card);
                game.informPlayers(controller.getLogName() + " turns " + card.getLogName() + " face down");
            }
            if (shellGamePile.isEmpty()) {
                return true;
            }
            Collections.shuffle(shellGamePile);
            game.informPlayers(controller.getLogName() + " shuffles the face-down pile");
            TargetCard targetCard = new TargetCard(Zone.HAND, new FilterCard());
            CardsImpl cards = new CardsImpl();
            cards.addAllCards(shellGamePile);
            if (opponent.choose(Outcome.Sacrifice, (Cards)cards, targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                card.setFaceDown(false, game);
                game.informPlayers(opponent.getLogName() + " reveals " + card.getLogName());
                if (card.getId().equals(sourceCard.getId())) {
                    Permanent sourcePermanent = game.getPermanent(source.getSourceId());
                    if (sourcePermanent != null) {
                        sourcePermanent.sacrifice(source, game);
                    }
                } else {
                    Permanent permanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
                    if (permanent != null) {
                        permanent.destroy(source, game, false);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

