/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class JangoFettEffect
extends OneShotEffect {
    JangoFettEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "it gets +X/+0, where X is the number of creatures defending player controls with a bounty counter on them";
    }

    private JangoFettEffect(JangoFettEffect ability) {
        super((OneShotEffect)ability);
    }

    public JangoFettEffect copy() {
        return new JangoFettEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getSourceId());
        if (creature == null) {
            return false;
        }
        UUID defenderId = game.getCombat().getDefendingPlayerId(creature.getId(), game);
        int count = 0;
        if (defenderId != null) {
            FilterCreaturePermanent bountyFilter = new FilterCreaturePermanent("creatures defending player controls with a bounty counter");
            bountyFilter.add((Predicate)CounterType.BOUNTY.getPredicate());
            count = game.getBattlefield().countAll((FilterPermanent)bountyFilter, defenderId, game);
        }
        if (count == 0) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostSourceEffect(count, 0, Duration.WhileOnBattlefield), source);
        return true;
    }
}

