/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JawsOfDefeatEffect
extends OneShotEffect {
    JawsOfDefeatEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent loses life equal to the difference between that creature's power and its toughness";
    }

    private JawsOfDefeatEffect(JawsOfDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public JawsOfDefeatEffect copy() {
        return new JawsOfDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (player == null || permanent == null) {
            return false;
        }
        int diff = Math.abs(permanent.getToughness().getValue() - permanent.getPower().getValue());
        return diff > 0 && player.loseLife(diff, game, source, false) > 0;
    }
}

