/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JayasPhoenixTriggeredAbility
extends DelayedTriggeredAbility {
    JayasPhoenixTriggeredAbility() {
        super((Effect)new CopyTargetStackObjectEffect(), Duration.EndOfTurn);
    }

    private JayasPhoenixTriggeredAbility(JayasPhoenixTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility != null && stackAbility.getStackAbility() instanceof LoyaltyAbility) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }

    public JayasPhoenixTriggeredAbility copy() {
        return new JayasPhoenixTriggeredAbility(this);
    }

    public String getRule() {
        return "copy the next loyalty ability you activate this turn when you activate it. You may choose new targets for the copy";
    }
}

