/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.cards.Card;
import mage.cards.j.JediTraining;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class JediTrainingTriggeredAbility
extends TriggeredAbilityImpl {
    public JediTrainingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ScryEffect(1));
    }

    private JediTrainingTriggeredAbility(JediTrainingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public JediTrainingTriggeredAbility copy() {
        return new JediTrainingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MEDITATED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return event.getPlayerId().equals(this.getControllerId()) && source != null && JediTraining.filter.match((Card)source, game);
    }

    public String getRule() {
        return "Whenever a Jedi creature you control meditates, scry 1";
    }
}

