/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class JelevaNephaliasWatcher
extends Watcher {
    private final Map<String, Integer> manaSpendToCast = new HashMap<String, Integer>();

    public JelevaNephaliasWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || game.getStack().isEmpty()) {
            return;
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell)) continue;
            Spell spell = (Spell)stackObject;
            this.manaSpendToCast.putIfAbsent(spell.getSourceId().toString() + spell.getCard().getZoneChangeCounter(game), spell.getSpellAbility().getManaCostsToPay().manaValue());
        }
    }

    public int getManaSpentToCastLastTime(UUID sourceId, int zoneChangeCounter) {
        return this.manaSpendToCast.getOrDefault(sourceId.toString() + zoneChangeCounter, 0);
    }

    public void reset() {
        super.reset();
        this.manaSpendToCast.clear();
    }
}

