/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class JestersScepterCost
extends CostImpl {
    public JestersScepterCost() {
        this.text = "Put a card exiled with {this} into its owner's graveyard";
    }

    private JestersScepterCost(JestersScepterCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            Card card;
            TargetCardInExile target = new TargetCardInExile(new FilterCard(), CardUtil.getCardExileZoneId((Game)game, (Ability)ability));
            target.withNotTarget(true);
            ExileZone cards = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)ability));
            if (cards != null && !cards.isEmpty() && controller.choose(Outcome.Benefit, (Cards)cards, (TargetCard)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null && controller.moveCardToGraveyardWithInfo(card, source, game, Zone.EXILED)) {
                if (card instanceof SplitCard) {
                    game.getState().setValue(source.getSourceId() + "_nameOfExiledCardPayment", (Object)((SplitCard)card).getLeftHalfCard().getName());
                    game.getState().setValue(source.getSourceId() + "_nameOfExiledCardPayment2", (Object)((SplitCard)card).getRightHalfCard().getName());
                } else if (card instanceof ModalDoubleFacedCard) {
                    game.getState().setValue(source.getSourceId() + "_nameOfExiledCardPayment", (Object)((ModalDoubleFacedCard)card).getLeftHalfCard().getName());
                    game.getState().setValue(source.getSourceId() + "_nameOfExiledCardPayment2", (Object)((ModalDoubleFacedCard)card).getRightHalfCard().getName());
                } else {
                    game.getState().setValue(source.getSourceId() + "_nameOfExiledCardPayment", (Object)card.getName());
                }
                this.paid = true;
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player player = game.getPlayer(controllerId);
        return player != null;
    }

    public JestersScepterCost copy() {
        return new JestersScepterCost(this);
    }
}

