/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class JetmirNexusOfRevelsEffect
extends ContinuousEffectImpl {
    JetmirNexusOfRevelsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Creatures you control get +1/+0 and have vigilance as long as you control three or more creatures.<br>Creatures you control also get +1/+0 and have trample as long as you control six or more creatures.<br>Creatures you control also get +1/+0 and have double strike as long as you control nine or more creatures.";
    }

    private JetmirNexusOfRevelsEffect(JetmirNexusOfRevelsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public JetmirNexusOfRevelsEffect copy() {
        return new JetmirNexusOfRevelsEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
        int level = Math.min(permanents.size() / 3, 3);
        if (level < 1) {
            return false;
        }
        block4: for (Permanent permanent : permanents) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)VigilanceAbility.getInstance(), source.getSourceId(), game);
                    if (level > 1) {
                        permanent.addAbility((Ability)TrampleAbility.getInstance(), source.getSourceId(), game);
                    }
                    if (level <= 2) continue block4;
                    permanent.addAbility((Ability)DoubleStrikeAbility.getInstance(), source.getSourceId(), game);
                    continue block4;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.ModifyPT_7c) continue block4;
                    permanent.addPower(level);
                    continue block4;
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

