/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class JeweledAmuletAddCounterEffect
extends OneShotEffect {
    private String manaUsedString;

    public JeweledAmuletAddCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "Note the type of mana spent to pay this activation cost";
    }

    private JeweledAmuletAddCounterEffect(JeweledAmuletAddCounterEffect effect) {
        super((OneShotEffect)effect);
        this.manaUsedString = effect.manaUsedString;
    }

    public JeweledAmuletAddCounterEffect copy() {
        return new JeweledAmuletAddCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent jeweledAmulet = game.getPermanent(source.getSourceId());
        if (controller != null && jeweledAmulet != null) {
            game.getState().setValue("JeweledAmulet" + source.getSourceId().toString(), (Object)source.getManaCostsToPay().getUsedManaToPay());
            this.manaUsedString = source.getManaCostsToPay().getUsedManaToPay().toString();
            jeweledAmulet.addInfo("MANA USED", CardUtil.addToolTipMarkTags((String)("Mana used last: " + this.manaUsedString)), game);
            return true;
        }
        return false;
    }
}

