/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColorOrArtifact;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class JeweledSpiritEffect
extends OneShotEffect {
    JeweledSpiritEffect() {
        super(Outcome.AddAbility);
        this.staticText = "{this} gains protection from artifacts or from the color of your choice until end of turn";
    }

    private JeweledSpiritEffect(JeweledSpiritEffect effect) {
        super((OneShotEffect)effect);
    }

    public JeweledSpiritEffect copy() {
        return new JeweledSpiritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColorOrArtifact choice = new ChoiceColorOrArtifact();
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game)) {
            FilterCard protectionFilter = new FilterCard();
            if (choice.isArtifactSelected()) {
                protectionFilter.add((Predicate)CardType.ARTIFACT.getPredicate());
            } else {
                protectionFilter.add((Predicate)new ColorPredicate(choice.getColor()));
            }
            protectionFilter.setMessage(choice.getChoice());
            ProtectionAbility protectionAbility = new ProtectionAbility((Filter)protectionFilter);
            GainAbilitySourceEffect effect = new GainAbilitySourceEffect((Ability)protectionAbility, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

