/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class JointAssaultBoostTargetEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;
    private MageObjectReference paired;

    public JointAssaultBoostTargetEffect(int power, int toughness, Duration duration) {
        super(duration, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.staticText = "Target creature gets +2/+2 until end of turn. If it's paired with a creature, that creature also gets +2/+2 until end of turn";
    }

    private JointAssaultBoostTargetEffect(JointAssaultBoostTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public JointAssaultBoostTargetEffect copy() {
        return new JointAssaultBoostTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        UUID permanentId = this.getTargetPointer().getFirst(game, source);
        Permanent target = game.getPermanent(permanentId);
        if (target != null && target.getPairedCard() != null) {
            this.paired = target.getPairedCard();
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent pairedPermanent;
        int affectedTargets = 0;
        UUID permanentId = this.getTargetPointer().getFirst(game, source);
        Permanent target = game.getPermanent(permanentId);
        if (target != null) {
            target.addPower(this.power);
            target.addToughness(this.toughness);
            ++affectedTargets;
        }
        if (this.paired != null && (pairedPermanent = this.paired.getPermanent(game)) != null) {
            pairedPermanent.addPower(this.power);
            pairedPermanent.addToughness(this.toughness);
            ++affectedTargets;
        }
        return affectedTargets > 0;
    }
}

