/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;

class JolraelEmpressOfBeastsEffect
extends OneShotEffect {
    JolraelEmpressOfBeastsEffect() {
        super(Outcome.Benefit);
        this.staticText = "All lands target player controls become 3/3 creatures until end of turn. They're still lands.";
    }

    private JolraelEmpressOfBeastsEffect(JolraelEmpressOfBeastsEffect effect) {
        super((OneShotEffect)effect);
    }

    public JolraelEmpressOfBeastsEffect copy() {
        return new JolraelEmpressOfBeastsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            FilterLandPermanent filter = new FilterLandPermanent();
            filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            game.addEffect((ContinuousEffect)new BecomesCreatureAllEffect((Token)new CreatureToken(3, 3), "lands", (FilterPermanent)filter, Duration.EndOfTurn, false), source);
            return true;
        }
        return false;
    }
}

