/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.abilities.effects.common.continuous.CantBeSacrificedSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JonIrenicusShatteredOneEffect
extends OneShotEffect {
    JonIrenicusShatteredOneEffect() {
        super(Outcome.Detriment);
        this.staticText = "target opponent gains control of up to one target creature you control. Put two +1/+1 counters on it and tap it. It's goaded for the rest of the game and it gains \"This creature can't be sacrificed.\"";
    }

    private JonIrenicusShatteredOneEffect(JonIrenicusShatteredOneEffect effect) {
        super((OneShotEffect)effect);
    }

    public JonIrenicusShatteredOneEffect copy() {
        return new JonIrenicusShatteredOneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(((Target)source.getTargets().get(0)).getFirstTarget());
        Permanent creature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (creature == null || opponent == null) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, opponent.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
        game.addEffect((ContinuousEffect)effect, source);
        game.processAction();
        creature.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        creature.tap(source, game);
        game.addEffect(new GoadTargetEffect().setDuration(Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTarget(creature, game)), source);
        game.addEffect(new GainAbilityTargetEffect((Ability)new SimpleStaticAbility((Effect)new CantBeSacrificedSourceEffect().setText("This creature can't be sacrificed")), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(creature, game)), source);
        return true;
    }
}

