/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.MustBeBlockedByAtLeastOneTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JoragaInvocationEffect
extends OneShotEffect {
    JoragaInvocationEffect() {
        super(Outcome.Detriment);
        this.staticText = "and must be blocked this turn if able";
    }

    private JoragaInvocationEffect(JoragaInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public JoragaInvocationEffect copy() {
        return new JoragaInvocationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                MustBeBlockedByAtLeastOneTargetEffect effect = new MustBeBlockedByAtLeastOneTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

