/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.BlockedAttackerWatcher;

class JovensFerretsEffect
extends OneShotEffect {
    JovensFerretsEffect() {
        super(Outcome.Benefit);
        this.staticText = "tap all creatures that blocked {this} this turn. They don't untap during their controller's next untap step.";
    }

    private JovensFerretsEffect(JovensFerretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public JovensFerretsEffect copy() {
        return new JovensFerretsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        BlockedAttackerWatcher watcher;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null && (watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class)) != null) {
            ArrayList<Permanent> toTap = new ArrayList<Permanent>();
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (creature.getId().equals(source.getSourceId()) || !watcher.creatureHasBlockedAttacker(sourcePermanent, creature, game)) continue;
                toTap.add(creature);
            }
            for (Permanent creature : toTap) {
                creature.tap(source, game);
                DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

