/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EscapeAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class JurassicParkEffect
extends ContinuousEffectImpl {
    JurassicParkEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each Dinosaur card in your graveyard has escape. The escape cost is equal to the card's mana cost plus exile three other cards from your graveyard.";
    }

    private JurassicParkEffect(JurassicParkEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.getGraveyard().getCards(game).stream().filter(Objects::nonNull).filter(card -> !card.getManaCost().getText().isEmpty()).filter(card -> card.hasSubtype(SubType.DINOSAUR, game)).forEach(card -> {
            EscapeAbility ability = new EscapeAbility(card, card.getManaCost().getText(), 3);
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        });
        return true;
    }

    public JurassicParkEffect copy() {
        return new JurassicParkEffect(this);
    }
}

