/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.MageObject;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.j.JusticeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JusticeTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedEvent> {
    JusticeTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new JusticeEffect());
    }

    private JusticeTriggeredAbility(JusticeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public JusticeTriggeredAbility copy() {
        return new JusticeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_BY_SOURCE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject != null && sourceObject.getColor(game).isRed() && (sourceObject instanceof Permanent && sourceObject.isCreature(game) || sourceObject instanceof Spell)) {
            ((Effect)this.getEffects().get(0)).setValue("damageAmount", (Object)event.getAmount());
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(game.getControllerId(sourceObject.getId())));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a red creature or spell deals damage, {this} deals that much damage to that creature's or spell's controller.";
    }
}

