/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileThenReturnTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class JusticiarsPortalEffect
extends OneShotEffect {
    JusticiarsPortalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target creature you control, then return that card to the battlefield under its owner's control. It gains first strike until end of turn.";
    }

    private JusticiarsPortalEffect(JusticiarsPortalEffect effect) {
        super((OneShotEffect)effect);
    }

    public JusticiarsPortalEffect copy() {
        return new JusticiarsPortalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        new ExileThenReturnTargetEffect(false, true).apply(game, source);
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

