/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterOwnedCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class ImbrahamDeanOfTheoryEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterOwnedCard("card you own in exile with a study counter on it");

    ImbrahamDeanOfTheoryEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Exile the top X cards of your library and put a study counter on each of them. Then you may put a card you own in exile with a study counter on it into your hand.";
    }

    private ImbrahamDeanOfTheoryEffect(ImbrahamDeanOfTheoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImbrahamDeanOfTheoryEffect copy() {
        return new ImbrahamDeanOfTheoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card2;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card2 : cards.getCards(game)) {
            if (card2 == null) continue;
            card2.addCounters(CounterType.STUDY.createInstance(), source.getControllerId(), source, game);
        }
        TargetCardInExile targetCard = new TargetCardInExile(0, 1, filter);
        targetCard.withNotTarget(true);
        player.choose(this.outcome, (Target)targetCard, source, game);
        card2 = game.getCard(targetCard.getFirstTarget());
        if (card2 != null) {
            player.moveCards(card2, Zone.HAND, source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterType.STUDY.getPredicate());
    }
}

