/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class KaaliaOfTheVastEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("an Angel, Demon, or Dragon creature card");

    public KaaliaOfTheVastEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put an Angel, Demon, or Dragon creature card from your hand onto the battlefield tapped and attacking that opponent.";
    }

    private KaaliaOfTheVastEffect(KaaliaOfTheVastEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaaliaOfTheVastEffect copy() {
        return new KaaliaOfTheVastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID defenderId;
        UUID cardId;
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.chooseUse(Outcome.PutCreatureInPlay, "Put an Angel, Demon, or Dragon creature card from your hand onto the battlefield tapped and attacking?", source, game)) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (target.canChoose(controller.getId(), source, game) && target.choose(this.outcome, controller.getId(), source.getSourceId(), source, game) && !target.getTargets().isEmpty() && (card = game.getCard(cardId = target.getFirstTarget())) != null && game.getCombat() != null && (defenderId = game.getCombat().getDefendingPlayerId(source.getSourceId(), game)) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
            Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (creature != null) {
                game.getCombat().addAttackerToCombat(card.getId(), defenderId, game);
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.ANGEL.getPredicate(), SubType.DEMON.getPredicate(), SubType.DRAGON.getPredicate()}));
    }
}

